#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion


namespace gov.va.med.vbecs.DAL.HL7AL.UnitTests
{
	[TestFixture]
	public class HL7AL_HL7NetworkErrorException : BaseTest
	{
		private static string _errorMessage = "Unit Test Exception";

		[SetUp]
		protected void SetUp()
		{
			this.BaseSetUp();
		}

		[TearDown]
		protected void TearDown()
		{}

		[Test]
		public void Constructor1_Pass()
		{
			HL7NetworkErrorException hl7Exc = new HL7NetworkErrorException();
			Assert.IsNotNull(hl7Exc);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.Untestable)]
		public void Constructor1_Fail()
		{}

		[Test]
		public void Constructor2_Pass()
		{
			HL7NetworkErrorException hl7Exc = new HL7NetworkErrorException(_errorMessage);
			Assert.IsNotNull(hl7Exc);
			Assert.IsTrue(hl7Exc.Message == _errorMessage);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.Untestable)]
		public void Constructor2_Fail()
		{}

		[Test]
		public void Constructor3_Pass()
		{
			HL7NetworkErrorException hl7Exc = new HL7NetworkErrorException(_errorMessage, new ArgumentNullException());
			Assert.IsNotNull(hl7Exc);
			Assert.IsTrue(hl7Exc.Message == _errorMessage);
			Assert.AreSame(hl7Exc.InnerException.GetType(), typeof(ArgumentNullException));
		}

		[Test]
		[Ignore(StandardIgnoreReasons.Untestable)]
		public void Constructor3_Fail()
		{}
	}
}
#endif
